/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define NUM_DRIPS 20

float Random( vec2 p )
{
//  return fract(cos(mod(12345678.,256.*dot(p,vec2(3.1415962,2.6651441426902)))));
    return fract(cos(dot(p,vec2(23.140692632779269,2.6651441426902251))) * 123456.);
}

vec2 dripPos (float fTime, out float fAge, vec2 p)
{
    float t = floor (fTime*0.1);
    fAge = fTime*0.1 - t;
    return vec2(Random(vec2(t+p)));
}

void main(void)
{
	vec2 vRel = gl_FragCoord.xy / iResolution.xy;

    float t = iGlobalTime;
    float fStep = 123.456;
    float fHeight = 0.0;
    
    for (int i = 0; i < NUM_DRIPS; i++)
    {
        float fAge;
        vec2 vRnd = dripPos (t, fAge, vRel);

        vec2 vD = vec2 (vRel - vRnd);
        float fD = sqrt (dot (vD, vD));
        float fDa = 10.0 * (fD - fAge + 0.6);

        fHeight += (1.0 - fAge) 
            * max (0.0, 1.0 - (fDa*fDa))
            * sin (fD*150.0 - fAge*80.0);
        
        t += fStep;
    }

//    vRel.y -= sign (fHeight) * fHeight*fHeight; // Original
    vRel.y -= fHeight*fHeight; // Tweaked
//    vRel.y -= fHeight; // Tweaked -- bigger spread
    vRel.y = 1. - vRel.y; // Bugfix Flip Y Texture
    vec4 vTex = texture2D (iChannel0, vRel);

    if (fHeight < 0.0)
    {
        float p = -fHeight*0.8;
        float q = 1.0 - p;
        vTex.b = p + q*vTex.b;
        p = -fHeight*0.3;
        q = 1.0 - p;
        vTex.g = p + q*vTex.g;
    }
    
    gl_FragColor = vTex; 
}